<?php
// ============================================================================
//  فایل 2: worker.php (Queue Processor)
// ============================================================================

// ----------------------------- PHP Limits -----------------------------------
@ini_set('max_execution_time', '0');
@set_time_limit(0);
@ini_set('memory_limit', '512M');

// ----------------------------- CONFIG ---------------------------------------
define('BOT_TOKEN', getenv('BOT_TOKEN') ?: '502379811:AAEctZp9HUY25usMhNXMeOlOsf3E_SGA7hc');
// !توجه: توکن زیبال خود را در اینجا قرار دهید
define('ZIBAL_MERCHANT', '835643740ba94c91960248d7245f47f8');
define('SOURCE_CHANNEL_ID', '-1003028729000');
define('DESTINATION_CHANNEL_ID', '-1002510404010');
const ADMIN_USER_IDS = [
    370237089,234067143,
];
const KEYWORD_REGEX = '/(زیبال|زیپال|زرین\s?پال)/iu';
const THROTTLE_MS = 1200;
const MAX_RETRIES = 6;

// ----------------------------- DIRECTORIES ----------------------------------
if (!defined('STATE_DIR')) { define('STATE_DIR', __DIR__ . DIRECTORY_SEPARATOR . '_state'); }
if (!is_dir(STATE_DIR)) { @mkdir(STATE_DIR, 0775, true); }
if (!defined('QUEUE_DIR')) { define('QUEUE_DIR', __DIR__ . DIRECTORY_SEPARATOR . '_queue'); }
if (!is_dir(QUEUE_DIR)) { @mkdir(QUEUE_DIR, 0775, true); }

// ============================================================================
//  Worker Main Logic
// ============================================================================
echo "Worker started at: " . date('Y-m-d H:i:s') . "\n";
$worker_lock = acquire_lock('worker_process');
if (!$worker_lock) {
    echo "Another worker process is already running. Exiting.\n";
    exit;
}
$files = glob(QUEUE_DIR . '/*.json');
if (empty($files)) {
    echo "Queue is empty. Exiting.\n";
    release_lock($worker_lock);
    exit;
}
sort($files);
$file_path = $files[0];
echo "Processing file: " . basename($file_path) . "\n";
$content = file_get_contents($file_path);
if ($content === false || empty(trim($content))) {
    echo "File is empty or unreadable. Deleting.\n";
    unlink($file_path);
    release_lock($worker_lock);
    exit;
}
$content_hash = sha1($content);
$done_key = 'processed_content:' . $content_hash;
if (is_done($done_key)) {
    echo "This file content has already been processed. Deleting.\n";
    unlink($file_path);
    release_lock($worker_lock);
    exit;
}
$count = process_json_dump_and_send($content, $content_hash);
mark_done($done_key);
unlink($file_path);
echo "Successfully processed $count pairs. File deleted.\n";
echo "Worker finished at: " . date('Y-m-d H:i:s') . "\n";
release_lock($worker_lock);

// ============================================================================
//  Processing Functions
// ============================================================================
function process_json_dump_and_send(string $json_content, ?string $content_hash = null): int {
    $data = json_decode($json_content, true);
    if (!is_array($data)) return 0;
    $messages = [];
    if (isset($data['messages']) && is_array($data['messages'])) {
        $messages = $data['messages'];
    } elseif (isset($data['chats']['list']) && is_array($data['chats']['list'])) {
        foreach ($data['chats']['list'] as $chat) {
            if (isset($chat['messages']) && is_array($chat['messages'])) {
                $messages = array_merge($messages, $chat['messages']);
            }
        }
    }
    if (!$messages) return 0;
    $by_id = [];
    foreach ($messages as $m) { if (isset($m['id'])) { $by_id[$m['id']] = $m; } }
    $pairs = [];
    foreach ($messages as $m) {
        if (isset($m['reply_to_message_id'], $by_id[$m['reply_to_message_id']])) {
            $reply_text = extract_text_array($m);
            if ($reply_text !== '' && preg_match(KEYWORD_REGEX, $reply_text)) {
                $pairs[] = ['original' => $by_id[$m['reply_to_message_id']], 'reply' => $m];
            }
        }
    }
    $count_text = 'تعداد کل: ' . count($pairs);
    if ($content_hash) {
        send_once(DESTINATION_CHANNEL_ID, $count_text, 'count:' . $content_hash);
    } else {
        safe_send(DESTINATION_CHANNEL_ID, $count_text);
    }
    sleep_ms(THROTTLE_MS);
    foreach ($pairs as $pair) {
        process_and_send_pair($pair['original'], $pair['reply']);
    }
    return count($pairs);
}

// ============================================================================
//  تابع پردازش و ارسال - ویرایش شده
// ============================================================================
function process_and_send_pair($original, $reply): void
{
    $original_text = is_array($original) ? extract_text_array($original) : extract_text($original);
    $reply_text    = is_array($reply)    ? extract_text_array($reply)    : extract_text($reply);
    [$order_id, $base_price, $card_number] = extract_fields($original_text, $reply_text);

    if (!$order_id || !$base_price || !$card_number) {
        $error_log = "⚠️ یک جفت پیام نادیده گرفته شد:\n\n" . "دلیل:\n";
        if (!$order_id)    $error_log .= "- شماره سفارش یافت نشد.\n";
        if (!$base_price)   $error_log .= "- قیمت یافت نشد.\n";
        if (!$card_number)  $error_log .= "- شماره کارت یافت نشد.\n";
        $original_message_id = is_array($original) ? $original['id'] : $original->message_id;
        $error_log .= "\n--- پیام اصلی (ID: $original_message_id) ---\n" . mb_substr($original_text, 0, 300) . "\n";
        $error_log .= "\n--- پیام ریپلای ---\n" . mb_substr($reply_text, 0, 300);
        safe_send(ADMIN_USER_IDS[0], $error_log);
        sleep_ms(THROTTLE_MS);
        return;
    }

    $final_price = (mb_strpos($reply_text, 'حق کنسلی') !== false) ? (int)$base_price : (int)round($base_price * 1.07);
    $formatted_price = number_format($final_price);
    
    // --- شروع منطق جدید ---
    $info = getCardInquiry($card_number);
    $iban_line = $info['iban'] ?? "(استعلام ناموفق)";
    $bank_line = $info['bankName'] ?? "—";
    $name_line = $info['fullName'] ?? trim(($info['firstName'] ?? '') . ' ' . ($info['lastName'] ?? ''));
    if ($name_line === '') { $name_line = "—"; }

    // ساخت پیام اول (با نام، نام بانک، شبا، کارت، مبلغ)
    $first_message = "نام: " . $name_line . "\n"
                   . "نام بانک: " . $bank_line . "\n"
                   . "شماره شبا: " . $iban_line . "\n"
                   . "شماره کارت: " . $card_number . "\n"
                   . "مبلغ واریزی: " . $formatted_price;

// ارسال پیام‌ها به صورت جداگانه
    safe_send(DESTINATION_CHANNEL_ID, $first_message);
    sleep_ms(THROTTLE_MS);

    safe_send(DESTINATION_CHANNEL_ID, $order_id);
    sleep_ms(THROTTLE_MS);
    
    safe_send(DESTINATION_CHANNEL_ID, '✅✅');
    sleep_ms(THROTTLE_MS);
    // --- پایان منطق جدید ---
}

function extract_fields(string $original_text, string $reply_text): array { $order_id = null; $base_price = null; $card_number = null; if (preg_match('/#(\d{1,12})/u', $original_text, $m)) { $order_id = '#' . $m[1]; } elseif (preg_match('/(?:شماره(?:\s|\x{200c})?سفارش)\s*[:：]?\s*(\d{1,12})/u', $original_text, $m)) { $order_id = '#' . $m[1]; } if (preg_match('/(?:قیمت|مبلغ)\s*(?:پایه)?\s*[:：]?\s*([\d\p{N}.,٬٫،\s]+)/u', $original_text, $m)) { $normalized = normalize_digits($m[1]); $normalized = preg_replace('/[.,٬٫،\s]/u', '', $normalized); if ($normalized !== '' && ctype_digit($normalized)) { $base_price = (int)$normalized; } } $reply_norm = normalize_digits($reply_text); if (preg_match('/\b\d{4}(?:[ -]?\d{4}){3}\b/u', $reply_norm, $m)) { $digits = preg_replace('/\D+/', '', $m[0]); if (strlen($digits) === 16) { $card_number = $digits; } } elseif (preg_match('/\b\d{16}\b/u', $reply_norm, $m)) { $card_number = $m[0]; } return [$order_id, $base_price, $card_number]; }
function callZibalApi(string $url, array $data): ?array { $headers = ["Content-Type: application/json", "Authorization: Bearer " . ZIBAL_MERCHANT]; $ch = curl_init($url); curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_HTTPHEADER => $headers, CURLOPT_POST => true, CURLOPT_POSTFIELDS => json_encode($data), CURLOPT_TIMEOUT => 15]); $result = curl_exec($ch); curl_close($ch); return $result ? json_decode($result, true) : null; }


/**
 * کارت → (شبا/نام/بانک)
 * خروجی:
 *   ['iban'=>?string, 'bankName'=>?string, 'firstName'=>?string, 'lastName'=>?string, 'fullName'=>?string]
 */
function getCardInquiry(string $card_number): array {
    $out = ['iban' => null, 'bankName' => null, 'firstName' => null, 'lastName' => null, 'fullName' => null];
    if (empty(ZIBAL_MERCHANT) || ZIBAL_MERCHANT === 'your_zibal_merchant_token_here') { return $out; }
    $url = "https://api.zibal.ir/v1/facility/cardToIban";
    $data = ["cardNumber" => $card_number];
    $response = callZibalApi($url, $data);

    if (is_array($response) && isset($response['result']) && (string)$response['result'] === '1' && isset($response['data']) && is_array($response['data'])) {
        $data = $response['data'];
        // IBAN
        if (isset($data['IBAN']) && is_string($data['IBAN'])) { $out['iban'] = $data['IBAN']; }
        elseif (isset($data['iban']) && is_string($data['iban'])) { $out['iban'] = $data['iban']; }
        elseif (isset($data['sheba']) && is_string($data['sheba'])) { $out['iban'] = $data['sheba']; }

        // Bank name
        if (isset($data['bankName']) && is_string($data['bankName'])) { $out['bankName'] = $data['bankName']; }
        elseif (isset($data['bank']) && is_string($data['bank'])) { $out['bankName'] = $data['bank']; }

        // Name(s)
        if (isset($data['name'])) {
            if (is_array($data['name'])) {
                // often as list of possible matches
                $first = $data['name'][0] ?? $data['name'];
                if (is_array($first)) {
                    if (isset($first['firstName']) && is_string($first['firstName'])) { $out['firstName'] = $first['firstName']; }
                    if (isset($first['lastName']) && is_string($first['lastName'])) { $out['lastName'] = $first['lastName']; }
                }
            } elseif (is_string($data['name'])) {
                $out['fullName'] = trim($data['name']);
            }
        } else {
            if (isset($data['firstName']) && is_string($data['firstName'])) { $out['firstName'] = $data['firstName']; }
            if (isset($data['lastName']) && is_string($data['lastName'])) { $out['lastName'] = $data['lastName']; }
        }

        if (empty($out['fullName'])) {
            $fn = trim((string)($out['firstName'] ?? ''));
            $ln = trim((string)($out['lastName'] ?? ''));
            $full = trim($fn . ' ' . $ln);
            if ($full !== '') { $out['fullName'] = $full; }
        }
    }
    return $out;
}

function getIban(string $card_number): ?string { if (empty(ZIBAL_MERCHANT) || ZIBAL_MERCHANT === 'your_zibal_merchant_token_here') { return null; } $url = "https://api.zibal.ir/v1/facility/cardToIban"; $data = ["cardNumber" => $card_number]; $response = callZibalApi($url, $data); if (isset($response['result']) && $response['result'] == 1 && !empty($response['data']['IBAN'])) { return $response['data']['IBAN']; } return null; }
function tgApiCall(string $method, array $params, string $http_method = 'POST') { $attempt = 0; while (true) { $attempt++; $url = 'https://api.telegram.org/bot' . BOT_TOKEN . '/' . $method; $ch = curl_init(); if ($http_method === 'GET') { $url .= '?' . http_build_query($params); } else { curl_setopt($ch, CURLOPT_POST, true); curl_setopt($ch, CURLOPT_POSTFIELDS, $params); } curl_setopt_array($ch, [CURLOPT_URL => $url, CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 20]); $out = curl_exec($ch); $http = curl_getinfo($ch, CURLINFO_HTTP_CODE); curl_close($ch); $json = $out ? json_decode($out, true) : null; if ($json && isset($json['ok']) && $json['ok']) { return $json; } $retry_after = 0; if ($json && isset($json['error_code']) && (int)$json['error_code'] === 429) { $retry_after = (int)($json['parameters']['retry_after'] ?? 0); } if ($http === 429 && !$retry_after) { $retry_after = 2; } if ($retry_after > 0) { sleep($retry_after + 1); } else { $delay = min((1 << min($attempt, 5)), 16); sleep($delay); } if ($attempt >= MAX_RETRIES) { return false; } } }
function safe_send($chat_id, $text, ?string $parse_mode = null): bool { $params = ['chat_id' => $chat_id, 'text' => $text]; if ($parse_mode) { $params['parse_mode'] = $parse_mode; } $res = tgApiCall('sendMessage', $params); return is_array($res) && $res['ok'] === true; }
function normalize_digits(string $s): string { $p = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹']; $a = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩']; $l = ['0','1','2','3','4','5','6','7','8','9']; return str_replace($a, $l, str_replace($p, $l, $s)); }
function extract_text_array(array $m): string { if (!isset($m['text'])) return ''; if (is_string($m['text'])) return $m['text']; if (is_array($m['text'])) return flatten_text_array($m['text']); return ''; }
function flatten_text_array(array $arr): string { $buf = ''; foreach ($arr as $part) { if (is_string($part)) { $buf .= $part; } elseif (is_array($part) && isset($part['text'])) { $buf .= (string)$part['text']; } } return $buf; }
function sleep_ms(int $ms): void { if ($ms > 0) usleep($ms * 1000); }
function mark_done(string $key): void { @file_put_contents(STATE_DIR . '/done_' . sha1($key), (string)time(), LOCK_EX); }
function is_done(string $key): bool { return is_file(STATE_DIR . '/done_' . sha1($key)); }
function acquire_lock(string $key) { $f = STATE_DIR . '/lock_' . sha1($key); $h = @fopen($f, 'c'); if (!$h) return false; if (!flock($h, LOCK_EX | LOCK_NB)) { fclose($h); return false; } return $h; }
function release_lock($h): void { if (is_resource($h)) { flock($h, LOCK_UN); fclose($h); } }
function send_once($chat_id, $text, string $key): bool { $flag = STATE_DIR . '/once_' . sha1($key); if (is_file($flag)) return true; $ok = safe_send($chat_id, $text); if ($ok) { @file_put_contents($flag, (string)time(), LOCK_EX); } return $ok; }