<?php
// ============================================================================
//  فایل 1: bot.php (Webhook Receiver)
// ============================================================================

// ----------------------------- PHP Limits -----------------------------------
@ini_set('max_execution_time', '30');
@set_time_limit(30);
@ini_set('memory_limit', '128M');

// ----------------------------- CONFIG ---------------------------------------
define('BOT_TOKEN', getenv('BOT_TOKEN') ?: '502379811:AAEctZp9HUY25usMhNXMeOlOsf3E_SGA7hc');
// !توجه: توکن زیبال خود را در اینجا قرار دهید
define('ZIBAL_MERCHANT', '835643740ba94c91960248d7245f47f8'); 
define('SOURCE_CHANNEL_ID', '-1003028729000');
define('DESTINATION_CHANNEL_ID', '-1002510404010');
const ADMIN_USER_IDS = [
    370237089,234067143, // آیدی عددی خودتان
];
const KEYWORD_REGEX = '/(زیبال|زیپال|زرین\s?پال)/iu';
const THROTTLE_MS = 1200;
const MAX_RETRIES = 6;

// ----------------------------- DIRECTORIES ----------------------------------
if (!defined('STATE_DIR')) { define('STATE_DIR', __DIR__ . DIRECTORY_SEPARATOR . '_state'); }
if (!is_dir(STATE_DIR)) { @mkdir(STATE_DIR, 0775, true); }
if (!defined('QUEUE_DIR')) { define('QUEUE_DIR', __DIR__ . DIRECTORY_SEPARATOR . '_queue'); }
if (!is_dir(QUEUE_DIR)) { @mkdir(QUEUE_DIR, 0775, true); }

// ----------------------------- BOOT -----------------------------------------
$raw = file_get_contents('php://input');
$update = json_decode($raw);
if (!$update) { http_response_code(200); exit; }

ack_and_continue(); // پاسخ فوری به تلگرام

// =========================== UPDATE ROUTING =================================
if (isset($update->channel_post)) {
    $post = $update->channel_post;
    if (!isset($post->chat->id) || (string)$post->chat->id !== (string)SOURCE_CHANNEL_ID) { exit; }
    if (isset($post->reply_to_message)) {
        $reply_text = extract_text($post);
        if ($reply_text !== '' && preg_match(KEYWORD_REGEX, $reply_text)) {
            process_and_send_pair($post->reply_to_message, $post);
        }
        exit;
    }
    if (isset($post->document) && is_json_document($post->document)) {
        handle_json_document($post->document, $post->chat->id, false);
        exit;
    }
    exit;
}

if (isset($update->message)) {
    $msg = $update->message;
    $chat_type = $msg->chat->type ?? null;
    $from_id = (int)($msg->from->id ?? 0);
    if ($chat_type === 'private' && in_array($from_id, ADMIN_USER_IDS, true)) {
        if (isset($msg->document) && is_json_document($msg->document)) {
            handle_json_document($msg->document, $msg->chat->id, true);
        } elseif (isset($msg->text) && trim($msg->text) === '/help') {
            sendMessage($msg->chat->id, "فایل JSON خروجی تلگرام را اینجا بفرستید تا در صف پردازش قرار گیرد.");
        }
    }
    exit;
}

// ============================================================================
//  Handler for JSON Documents
// ============================================================================
function handle_json_document($document, $chat_id, bool $is_admin_chat): void
{
    $uniq = $document->file_unique_id ?? $document->file_id;
    $key  = 'jsondoc:' . $uniq;
    $lock = acquire_lock($key);
    if (!$lock) { exit; }
    if (is_done($key)) {
        if ($is_admin_chat) { sendMessage($chat_id, "ℹ️ این فایل قبلاً در صف قرار گرفته است."); }
        release_lock($lock);
        exit;
    }
    $content = download_file_content($document->file_id);
    if ($content !== null) {
        $queue_filename = QUEUE_DIR . DIRECTORY_SEPARATOR . time() . '_' . $uniq . '.json';
        @file_put_contents($queue_filename, $content);
        mark_done($key);
        if ($is_admin_chat) {
            sendMessage($chat_id, "✅ فایل با موفقیت دریافت و در صف پردازش قرار گرفت.");
        }
    } else {
        if ($is_admin_chat) {
            sendMessage($chat_id, "❌ دریافت فایل از تلگرام ناموفق بود.");
        }
    }
    release_lock($lock);
}

// ============================================================================
//  Core Functions
// ============================================================================
function tgApiCall(string $method, array $params, string $http_method = 'POST') {
    $url = 'https://api.telegram.org/bot' . BOT_TOKEN . '/' . $method;
    $ch = curl_init();
    if ($http_method === 'GET') {
        $url .= '?' . http_build_query($params);
    } else {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    }
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    $out = curl_exec($ch);
    curl_close($ch);
    $json = $out ? json_decode($out, true) : null;
    return ($json && isset($json['ok']) && $json['ok']) ? $json : false;
}

function sendMessage($chat_id, $text): bool {
    $res = tgApiCall('sendMessage', ['chat_id' => $chat_id, 'text' => $text]);
    return (bool)$res;
}

function download_file_content(string $file_id): ?string {
    $res = tgApiCall('getFile', ['file_id' => $file_id], 'GET');
    if (empty($res['result']['file_path'])) return null;
    $file_path = $res['result']['file_path'];
    $url = 'https://api.telegram.org/file/bot' . BOT_TOKEN . '/' . $file_path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    $content = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ($content !== false && $code === 200) ? $content : null;
}

// ============================================================================
//  تابع پردازش و ارسال - ویرایش شده
// ============================================================================
function process_and_send_pair($original, $reply): void {
    $original_text = is_array($original) ? extract_text_array($original) : extract_text($original);
    $reply_text = is_array($reply) ? extract_text_array($reply) : extract_text($reply);
    
    [$order_id, $base_price, $card_number] = extract_fields($original_text, $reply_text);
    
    if (!$order_id || !$base_price || !$card_number) {
        return;
    }
    
    $final_price = (mb_strpos($reply_text, 'حق کنسلی') !== false) ? (int)$base_price : (int)round($base_price * 1.07);
    $formatted_price = number_format($final_price);

    // --- شروع منطق جدید ---
    $info = getCardInquiry($card_number);
    $iban_line = $info['iban'] ?? "(استعلام ناموفق)";
    $bank_line = $info['bankName'] ?? "—";
    $name_line = $info['fullName'] ?? trim(($info['firstName'] ?? '') . ' ' . ($info['lastName'] ?? ''));
    if ($name_line === '') { $name_line = "—"; }

    // ساخت پیام اول (با نام، نام بانک، شبا، کارت، مبلغ)
    $first_message = "نام: " . $name_line . "\n"
                   . "نام بانک: " . $bank_line . "\n"
                   . "شماره شبا: " . $iban_line . "\n"
                   . "شماره کارت: " . $card_number . "\n"
                   . "مبلغ واریزی: " . $formatted_price;

// ارسال پیام‌ها به صورت جداگانه
    tgApiCall('sendMessage', ['chat_id' => DESTINATION_CHANNEL_ID, 'text' => $first_message]);
    sleep_ms(THROTTLE_MS);

    tgApiCall('sendMessage', ['chat_id' => DESTINATION_CHANNEL_ID, 'text' => $order_id]);
    sleep_ms(THROTTLE_MS);
    
    tgApiCall('sendMessage', ['chat_id' => DESTINATION_CHANNEL_ID, 'text' => '✅✅']);
    sleep_ms(THROTTLE_MS);
    // --- پایان منطق جدید ---
}

function extract_fields(string $original_text, string $reply_text): array { $order_id = null; $base_price = null; $card_number = null; if (preg_match('/#(\d{1,12})/u', $original_text, $m)) { $order_id = '#' . $m[1]; } elseif (preg_match('/(?:شماره(?:\s|\x{200c})?سفارش)\s*[:：]?\s*(\d{1,12})/u', $original_text, $m)) { $order_id = '#' . $m[1]; } if (preg_match('/(?:قیمت|مبلغ)\s*(?:پایه)?\s*[:：]?\s*([\d\p{N}.,٬٫،\s]+)/u', $original_text, $m)) { $normalized = normalize_digits($m[1]); $normalized = preg_replace('/[.,٬٫،\s]/u', '', $normalized); if ($normalized !== '' && ctype_digit($normalized)) { $base_price = (int)$normalized; } } $reply_norm = normalize_digits($reply_text); if (preg_match('/\b\d{4}(?:[ -]?\d{4}){3}\b/u', $reply_norm, $m)) { $digits = preg_replace('/\D+/', '', $m[0]); if (strlen($digits) === 16) { $card_number = $digits; } } elseif (preg_match('/\b\d{16}\b/u', $reply_norm, $m)) { $card_number = $m[0]; } return [$order_id, $base_price, $card_number]; }
function callZibalApi(string $url, array $data): ?array { $headers = ["Content-Type: application/json", "Authorization: Bearer " . ZIBAL_MERCHANT]; $ch = curl_init($url); curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_HTTPHEADER => $headers, CURLOPT_POST => true, CURLOPT_POSTFIELDS => json_encode($data), CURLOPT_TIMEOUT => 15]); $result = curl_exec($ch); curl_close($ch); return $result ? json_decode($result, true) : null; }


/**
 * کارت → (شبا/نام/بانک)
 * خروجی:
 *   ['iban'=>?string, 'bankName'=>?string, 'firstName'=>?string, 'lastName'=>?string, 'fullName'=>?string]
 */
function getCardInquiry(string $card_number): array {
    $out = ['iban' => null, 'bankName' => null, 'firstName' => null, 'lastName' => null, 'fullName' => null];
    if (empty(ZIBAL_MERCHANT) || ZIBAL_MERCHANT === 'your_zibal_merchant_token_here') { return $out; }
    $url = "https://api.zibal.ir/v1/facility/cardToIban";
    $data = ["cardNumber" => $card_number];
    $response = callZibalApi($url, $data);

    if (is_array($response) && isset($response['result']) && (string)$response['result'] === '1' && isset($response['data']) && is_array($response['data'])) {
        $data = $response['data'];
        // IBAN
        if (isset($data['IBAN']) && is_string($data['IBAN'])) { $out['iban'] = $data['IBAN']; }
        elseif (isset($data['iban']) && is_string($data['iban'])) { $out['iban'] = $data['iban']; }
        elseif (isset($data['sheba']) && is_string($data['sheba'])) { $out['iban'] = $data['sheba']; }

        // Bank name
        if (isset($data['bankName']) && is_string($data['bankName'])) { $out['bankName'] = $data['bankName']; }
        elseif (isset($data['bank']) && is_string($data['bank'])) { $out['bankName'] = $data['bank']; }

        // Name(s)
        if (isset($data['name'])) {
            if (is_array($data['name'])) {
                // often as list of possible matches
                $first = $data['name'][0] ?? $data['name'];
                if (is_array($first)) {
                    if (isset($first['firstName']) && is_string($first['firstName'])) { $out['firstName'] = $first['firstName']; }
                    if (isset($first['lastName']) && is_string($first['lastName'])) { $out['lastName'] = $first['lastName']; }
                }
            } elseif (is_string($data['name'])) {
                $out['fullName'] = trim($data['name']);
            }
        } else {
            if (isset($data['firstName']) && is_string($data['firstName'])) { $out['firstName'] = $data['firstName']; }
            if (isset($data['lastName']) && is_string($data['lastName'])) { $out['lastName'] = $data['lastName']; }
        }

        if (empty($out['fullName'])) {
            $fn = trim((string)($out['firstName'] ?? ''));
            $ln = trim((string)($out['lastName'] ?? ''));
            $full = trim($fn . ' ' . $ln);
            if ($full !== '') { $out['fullName'] = $full; }
        }
    }
    return $out;
}

function getIban(string $card_number): ?string { if (empty(ZIBAL_MERCHANT) || ZIBAL_MERCHANT === 'your_zibal_merchant_token_here') { return null; } $url = "https://api.zibal.ir/v1/facility/cardToIban"; $data = ["cardNumber" => $card_number]; $response = callZibalApi($url, $data); if (isset($response['result']) && $response['result'] == 1 && !empty($response['data']['IBAN'])) { return $response['data']['IBAN']; } return null; }
function normalize_digits(string $s): string { $p = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹']; $a = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩']; $l = ['0','1','2','3','4','5','6','7','8','9']; return str_replace($a, $l, str_replace($p, $l, $s)); }
function sleep_ms(int $ms): void { if ($ms > 0) usleep($ms * 1000); }
function extract_text($obj): string { if (empty($obj->text)) return ''; return is_string($obj->text) ? $obj->text : ''; }
function extract_text_array(array $m): string { if (!isset($m['text'])) return ''; if (is_string($m['text'])) return $m['text']; if (is_array($m['text'])) return flatten_text_array($m['text']); return ''; }
function flatten_text_array(array $arr): string { $buf = ''; foreach ($arr as $part) { if (is_string($part)) { $buf .= $part; } elseif (is_array($part) && isset($part['text'])) { $buf .= (string)$part['text']; } } return $buf; }
function is_json_document($document): bool { return ($document->mime_type ?? '') === 'application/json' || preg_match('/\.json$/i', $document->file_name ?? ''); }
function ack_and_continue(): void { if (PHP_SAPI === 'cli' || headers_sent()) return; ignore_user_abort(true); http_response_code(200); header('Connection: close'); header('Content-Type: text/plain'); echo 'OK'; $size = ob_get_length(); if ($size !== false) { header("Content-Length: $size"); } @ob_end_flush(); @flush(); if (function_exists('fastcgi_finish_request')) { @fastcgi_finish_request(); } }
function mark_done(string $key): void { @file_put_contents(STATE_DIR . '/done_' . sha1($key), (string)time(), LOCK_EX); }
function is_done(string $key): bool { return is_file(STATE_DIR . '/done_' . sha1($key)); }
function acquire_lock(string $key) { $h = @fopen(STATE_DIR . '/lock_' . sha1($key), 'c'); if (!$h) return false; if (!flock($h, LOCK_EX | LOCK_NB)) { fclose($h); return false; } return $h; }
function release_lock($h): void { if (is_resource($h)) { flock($h, LOCK_UN); fclose($h); } }